library ATPSortLines;

uses
  SysUtils, Classes;

function ProcessText(Text: Pchar): PChar; stdcall;
var
  SText: String;
  SL: TStringList;
begin
  SText := String(Text);

  // Utiliza a classe TStrings para ordenar as linhas do Texto;
  SL := TStringList.Create;
  try
    SL.Text := SText;
    SL.Sort;
    SText := SL.Text;
  finally
    SL.Free;

    // Aloca Memria para o String de retorno (+1 para ter espao para o terminador nulo do string)
    GetMem(Result,Length(SText)+1);

    // Copia o String para a rea de memria alocada
    Result := StrPCopy(Result,SText);

  end;
end;

function GetDescription: PChar; stdcall;
begin
  Result := Pchar('Ordenar Linhas');
end;

function GetShortCut: PChar; stdcall;
begin
  Result := Pchar('SHIFT+CTRL+ALT+O');
end;


exports ProcessText, GetDescription, GetShortCut;



{$R *.res}

begin
end.

